/*
 * Decompiled with CFR 0.152.
 */
package Data_Structures.Structures.Fast;

import Data_Structures.ADTs.Queue;
import Data_Structures.Structures.Fast.FastNode;
import Data_Structures.Structures.Fast.FastStructure;
import Data_Structures.Structures.Pair;
import java.util.Iterator;

public class FastQueue<E>
extends FastStructure
implements Queue<E>,
Iterable<E> {
    private FastNode head = null;
    private FastNode tail = null;
    int size = 0;

    @Override
    public E deq() {
        if (this.isEmpty()) {
            throw new Error("Cannot deq from empty queue!");
        }
        Object output = this.head.data;
        FastNode old_head = this.head;
        this.head = this.head.link;
        FastQueue.yard_push(old_head);
        if (this.head == null) {
            this.tail = null;
        }
        --this.size;
        return (E)output;
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            throw new Error("Cannot Peep at the head of an empty stack.");
        }
        return (E)this.head.data;
    }

    @Override
    public void enq(E elem) {
        FastNode new_tail = FastQueue.newNode();
        new_tail.data = elem;
        if (this.head == null) {
            this.head = new_tail;
            this.tail = new_tail;
            this.size = 1;
            return;
        }
        this.tail.link = new_tail;
        this.tail = new_tail;
        ++this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public Queue<E> enq_static(E elem) {
        FastQueue<E> output = this.shallow_clone();
        output.enq(elem);
        return output;
    }

    @Override
    public Pair<E, Queue<E>> deq_static() {
        FastQueue<E> output = this.shallow_clone();
        E elem = output.peek();
        output.head = output.head.link;
        return new Pair<E, FastQueue<E>>(elem, output);
    }

    private FastQueue<E> shallow_clone() {
        FastQueue<E> output = new FastQueue<E>();
        output.head = this.head;
        output.tail = this.tail;
        output.size = this.size;
        return output;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new iter();
    }

    private class iter
    implements Iterator<E> {
        FastNode current;

        private iter() {
            this.current = FastQueue.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current != FastQueue.this.tail;
        }

        @Override
        public E next() {
            this.current = this.current.link;
            return this.current.data;
        }

        @Override
        public void remove() {
            throw new Error("Not Yet Implemented");
        }
    }
}

